require( "scripts/chocshopstyle.lua" );

shadowoffset = 3;
insideGame = AreInsideGame();


check_off_style = {
    x = 5,
    y = 0,
    w = kMax-0,
    h = kMax-0,
    label = "options_off",
    font = {edwardian_medium, 18, FColor(1.0,0,0)},
    flags = kHAlignCenter + kVAlignCenter,
};
check_off_shadow = {
    parent = check_off_style,
    x = 7,
    y = 2,
    font = {edwardian_medium, 18, ShadowColor},
};
check_on_style = {
    x = 5,
    y = 0,
    w = kMax-0,
    h = kMax-0,
    label = "options_on",
    font = {edwardian_medium, 18, FColor(0,0.7,0.2)},
    flags = kHAlignCenter + kVAlignCenter,
};
check_on_shadow = {
    parent = check_on_style,
    x = 7,
    y = 2,
    font = {edwardian_medium, 18, ShadowColor},
};

check_button_text = {
	SelectLayer(0),
    SetStyle(check_off_shadow),
    Text{},
    SetStyle(check_off_style),
	Text{},
	SelectLayer(2),
    SetStyle(check_off_shadow),
    Text{},
	SetStyle(check_off_style),
	Text{},
	SelectLayer(1),
	SetStyle(check_on_shadow),
	Text{},
	SetStyle(check_on_style),
	Text{},
	SelectLayer(3),
	SetStyle(check_on_shadow),
	Text{},
	SetStyle(check_on_style),
	Text{},
};

function LaunchWorldMap()
    SwapToModal("scripts/worldmap.lua");
end
MakeDialog
{
	name = "options",
	
	VTintWindow{
	    x = 0, y = 0, w = 800, h = 600,
	    color = Color(0,0,0,200),
	    time = 300,
	    fade = true,
	},
	
	RBounceWindow
	{
		x = kCenter + 800,
		y = 0,
		w = 800,
		h = 600,
		targetposx	= 0,
		targetposy	= 0,
		bouncelen	= 300,
		bouncefunc	= "sincx",
		alpha = true,
		
		Bitmap{
		    x = 104,
		    y = 22,
		    image	= "ui/backgrounds/options",
		    mask    = "ui/backgrounds/options.mask",
		},
		VObjectWindow {
		    x = 0, y = 0, w = kMax, h = kMax,
		    objects = {
		        steam = {
		            baseDir = "ui/",
		            name = "steam_anim",
		            continuous = true,
		            mouse = false,
		            assets = {
		                anim = {
		                    { state = "default", file = "anim_steam" },
		                },
		            },
		        },
		    },
		},
		
		TOptions
		{
			x = 0,
			y = 0,
			w = kMax,
			h = kMax,
			
			-- OPTIONS title
			--[[Text --shadow
			{
				x		= 250,
				y		= 96 + shadowoffset,
				w		= 310,
				h		= 50,
				font	= Options_TitleFontShadow,
				flags	= kHAlignCenter + kVAlignCenter,
				label	= "options_title"
			},]]
			Text --text
			{
				x		= 247,
				y		= 98,
				w		= 310,
				h		= 50,
				font	= Options_TitleFont,
				flags	= kHAlignCenter + kVAlignCenter,
				label	= "#<outline color='545050' size='1'>"..GetString( 'options_title' ).."</outline>"
			},
			
			
			SetStyle( CSOptionsSliderStyle ),
			
			---------------------------------------------- SFX Slider
			Text --text
			{
				x		= 175,
				y		= 155,
				w		= 90,
				h		= 50,
				font	= Options_SliderFont,
				flags	= kHAlignCenter + kVAlignCenter,
				label	= "#<outline color='545050' size='1'>"..GetString( 'options_sfxlevel' ).."</outline>"
			},
			
			Bitmap
			{
				x		= 288,
				y		= 170,
				w		= 301,
				h		= 36,
				image	= "ui/slider/slider_background",
			},
			
			Bitmap
			{
				name	= "sound_fill",
				x		= 288,
				y		= 170,
				w		= 301,
				h		= 36,
				image	= "ui/slider/slider_fill",
			},
			
			TSlider
			{
				x		= 288-31,
				y		= 150,
				w		= 301+54,
				h		= 36,
				name	= "options_sfxlevel_slider"
			},
			
			--[[Bitmap --start image
			{
				x		= 272,
				y		= 181,
				image	= "ui/slider/sound_slider_start",
			},
			Bitmap --end image
			{
				x		= 572,
				y		= 169,
				image	= "ui/slider/sound_slider_end",
			},]]
			
			---------------------------------------------- Music Slider
			Text --text
			{
				x		= 175,
				y		= 220,
				w		= 90,
				h		= 50,
				font	= Options_SliderFont,
				flags	= kHAlignCenter + kVAlignCenter,
				label	= "#<outline color='545050' size='1'>"..GetString( 'options_musiclevel' ).."</outline>"
			},
			
			
			Bitmap
			{
				x		= 288,
				y		= 243,
				w		= 301,
				h		= 36,			
				image	= "ui/slider/slider_background",
			},
			
			Bitmap
			{
				name	= "music_fill",
				x		= 288,
				y		= 243,
				w		= 301,
				h		= 36,
				image	= "ui/slider/slider_fill",
			},
			
			TSlider
			{
				x		= 288-31,
				y		= 223,
				w		= 301+54,
				h		= 36,
				name	= "options_musiclevel_slider"
			},
			
			--[[Bitmap --start image
			{
				x		= 272,
				y		= 252,
				image	= "ui/slider/music_slider_start",
			},
			Bitmap --end image
			{
				x		= 572,
				y		= 242,
				image	= "ui/slider/music_slider_end",
			},]]
            
            --SetStyle( CSCheckBoxStyle ),
			---------------------------------------------- Fullscreen
			Text
			{
				x		= 201,
				y		= 338,
				w		= 106,
				h		= 31,
				font	= {edwardian_medium, 22, WhiteColor},
				flags	= kHAlignCenter + kVAlignCenter,
				label   = "options_fullscreen",
				--label	= "#<outline color='545050' size='1'>"..GetString( 'options_fullscreen' ).."</outline>"
			},	
			Button
			{
				x		= 324,
				y		= 338,
				--w		= 60,
				--h		= 60,
				type    = kToggle,
				name	= "options_fullscreen_checkbox",
				graphics= {"ui/buttons/cs_check_base"},
				
				Group( check_button_text ),
				
				command	=
					function()
						if( ToggleFullScreen() == false ) then
							DisplayDialog { "scripts/ok.lua", body = "options_screenswitchfailed", title = "options_playground" };
						end
					end
			},
			
			---------------------------------------------- Mute All
			Text --text
			{
				x		= 201,
				y		= 295,
				w		= 106,
				h		= 31,
				font	= {edwardian_medium, 24, WhiteColor},
				flags	= kHAlignCenter + kVAlignCenter,
				label   = "options_muteall",
				--label	= "#<outline color='545050' size='1'>"..GetString( 'options_muteall' ).."</outline>"
			},
			Button
			{
				x		= 324,
				y		= 295,
				--w		= 60,
				--h		= 60,
				type    = kToggle,
				name	= "options_muteall_checkbox",
			    graphics= {"ui/buttons/cs_check_base"},
				Group( check_button_text ),
				command =
					function()
						ToggleSoundMute();
					end
			},
			---------------------------------------------- Tutorials
			Text{
			    label = "app_tutorials",
			    x = 201, 
			    y = 380, 
			    w = 106, 
			    h = 31,
			    flags = kVAlignCenter + kHAlignCenter,
			    font	= {edwardian_medium, 24, WhiteColor},
			},
			Button {
				x		= 324,
				y		= 380,
				--w		= 60,
				--h		= 60,
				type    = kToggle,
				name	= "options_tutorials_checkbox",
				graphics= {"ui/buttons/cs_check_base"},
				Group( check_button_text ),
			},
			
			---------------------------------------------- OK
			SetStyle(CSMMOvalButtonStyle),
			Button
			{
				x		= 345,
				y		= 445,
				name	= "options_close",
				Text{
				    x = 0, y = 0, w = kMax - 2, h = kMax - 9,
				    label	= "app_close",
				    font    = { edwardian_medium, 20, WhiteColor },
				    flags   = kHAlignCenter + kVAlignCenter,
				},
				command =
					function()
						InsideGame(insideGame);
						PostMessage( CreateNamedMessage( kTintOff, "" ) );
						DoTransition( kBounceThrough );
						SaveVolumes(); 
						PopModal( 'options' );
					end
			},
			
			---------------------------------------------- Credits
			SetStyle(CSMMLargeButtonStyle),
			Button
			{
				x		= 465,
				y		= 310,
				name	= "options_credits_button",
				Text{
					font = CSMainMenuFont,
					x = 0, y = 0,
					w = kMax, h = kMax - 16,
					flags	= kHAlignCenter + kVAlignCenter,
					label	= "options_credits"
				},
				command =
					function()
						DoTransition( kFadeToBlack );
						DoModal( 'scripts/credits.lua' );
					end
			},
			
		},
	},
}
InsideGame(false);
